const { app, BrowserWindow } = require('electron');

const args = process.argv.slice(2);
const params = Object.fromEntries(args.map(arg => arg.split('=')));

function createWindow () {
  const win = new BrowserWindow({
    fullscreen: true,           // Fullscreen mode
    frame: false,               // No title bar or window controls
    webPreferences: {
      nodeIntegration: false,
      contextIsolation: true
    }
  });

  // Build dynamic URL from passed parameters
  const url = `http://69.30.247.235?game=${params.game}&company=${params.company}&agent=${params.agent}&version=${params.version}`;
  
  win.loadURL(url);
}

app.whenReady().then(createWindow);
